//
//  MCStackAnimatingPaneHeader.h
//  MCApplication
//
//  Created by Ali Lalani on 8/7/04.
//  Copyright 2004 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MCStackView.h"
#import "MCStackViewDefines.h"

typedef enum _MCStackAnimatingPaneHeaderStyle {
    MCStackAnimatingPaneHeaderSlide					= 0,
    MCStackAnimatingPaneHeaderFade					= 1,    
} MCStackAnimatingPaneHeaderStyle;

@interface MCStackAnimatingPaneHeader : NSView {
	NSImage *oldHeader;
	NSImage *newHeader;
	
	BOOL isMovingDown;
	
	MCStackAnimatingPaneHeaderStyle animationStyle;
}
+ (MCStackAnimatingPaneHeader *)animatingPaneHeaderWithFrame:(NSRect)frame oldImage:(NSImage *)oldImage newImage:(NSImage *)newImage isMovingDown:(BOOL)direction;

- (MCStackView *)stackView;
- (void)setOldHeader:(NSImage *)anImage;
- (void)setNewHeader:(NSImage *)anImage;
- (void)setIsMovingDown:(BOOL)aBool;

- (void)setAnimationStyle:(MCStackAnimatingPaneHeaderStyle)animationStyle;

@end
